/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DisableRadiusRequestMarshaller
implements Marshaller<Request<DisableRadiusRequest>, DisableRadiusRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DisableRadiusRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DisableRadiusRequest> marshall(DisableRadiusRequest disableRadiusRequest) {
        if (disableRadiusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableRadiusRequest> request = new DefaultRequest<DisableRadiusRequest>(disableRadiusRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DisableRadius");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disableRadiusRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(disableRadiusRequest.getDirectoryId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

