/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DirectoryConnectSettings
implements Serializable,
Cloneable {
    private String vpcId;
    private SdkInternalList<String> subnetIds;
    private SdkInternalList<String> customerDnsIps;
    private String customerUserName;

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public DirectoryConnectSettings withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new SdkInternalList();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new SdkInternalList<String>(subnetIds);
    }

    public DirectoryConnectSettings withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new SdkInternalList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public DirectoryConnectSettings withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<String> getCustomerDnsIps() {
        if (this.customerDnsIps == null) {
            this.customerDnsIps = new SdkInternalList();
        }
        return this.customerDnsIps;
    }

    public void setCustomerDnsIps(Collection<String> customerDnsIps) {
        if (customerDnsIps == null) {
            this.customerDnsIps = null;
            return;
        }
        this.customerDnsIps = new SdkInternalList<String>(customerDnsIps);
    }

    public DirectoryConnectSettings withCustomerDnsIps(String ... customerDnsIps) {
        if (this.customerDnsIps == null) {
            this.setCustomerDnsIps(new SdkInternalList<String>(customerDnsIps.length));
        }
        for (String ele : customerDnsIps) {
            this.customerDnsIps.add(ele);
        }
        return this;
    }

    public DirectoryConnectSettings withCustomerDnsIps(Collection<String> customerDnsIps) {
        this.setCustomerDnsIps(customerDnsIps);
        return this;
    }

    public void setCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
    }

    public String getCustomerUserName() {
        return this.customerUserName;
    }

    public DirectoryConnectSettings withCustomerUserName(String customerUserName) {
        this.setCustomerUserName(customerUserName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getCustomerDnsIps() != null) {
            sb.append("CustomerDnsIps: ").append(this.getCustomerDnsIps()).append(",");
        }
        if (this.getCustomerUserName() != null) {
            sb.append("CustomerUserName: ").append(this.getCustomerUserName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettings)) {
            return false;
        }
        DirectoryConnectSettings other = (DirectoryConnectSettings)obj;
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getCustomerDnsIps() == null ^ this.getCustomerDnsIps() == null) {
            return false;
        }
        if (other.getCustomerDnsIps() != null && !other.getCustomerDnsIps().equals(this.getCustomerDnsIps())) {
            return false;
        }
        if (other.getCustomerUserName() == null ^ this.getCustomerUserName() == null) {
            return false;
        }
        return other.getCustomerUserName() == null || other.getCustomerUserName().equals(this.getCustomerUserName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerDnsIps() == null ? 0 : this.getCustomerDnsIps().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerUserName() == null ? 0 : this.getCustomerUserName().hashCode());
        return hashCode;
    }

    public DirectoryConnectSettings clone() {
        try {
            return (DirectoryConnectSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

