/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.DescribeConnectionLoaRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeConnectionLoaRequestMarshaller
implements Marshaller<Request<DescribeConnectionLoaRequest>, DescribeConnectionLoaRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeConnectionLoaRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeConnectionLoaRequest> marshall(DescribeConnectionLoaRequest describeConnectionLoaRequest) {
        if (describeConnectionLoaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeConnectionLoaRequest> request = new DefaultRequest<DescribeConnectionLoaRequest>(describeConnectionLoaRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.DescribeConnectionLoa");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeConnectionLoaRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(describeConnectionLoaRequest.getConnectionId());
            }
            if (describeConnectionLoaRequest.getProviderName() != null) {
                jsonGenerator.writeFieldName("providerName").writeValue(describeConnectionLoaRequest.getProviderName());
            }
            if (describeConnectionLoaRequest.getLoaContentType() != null) {
                jsonGenerator.writeFieldName("loaContentType").writeValue(describeConnectionLoaRequest.getLoaContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

