/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costandusagereport;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.costandusagereport.AWSCostAndUsageReportAsync;
import com.amazonaws.services.costandusagereport.AWSCostAndUsageReportClient;
import com.amazonaws.services.costandusagereport.model.DeleteReportDefinitionRequest;
import com.amazonaws.services.costandusagereport.model.DeleteReportDefinitionResult;
import com.amazonaws.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import com.amazonaws.services.costandusagereport.model.DescribeReportDefinitionsResult;
import com.amazonaws.services.costandusagereport.model.PutReportDefinitionRequest;
import com.amazonaws.services.costandusagereport.model.PutReportDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCostAndUsageReportAsyncClient
extends AWSCostAndUsageReportClient
implements AWSCostAndUsageReportAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCostAndUsageReportAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSCostAndUsageReportAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCostAndUsageReportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCostAndUsageReportAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteReportDefinitionResult> deleteReportDefinitionAsync(DeleteReportDefinitionRequest request) {
        return this.deleteReportDefinitionAsync(request, null);
    }

    @Override
    public Future<DeleteReportDefinitionResult> deleteReportDefinitionAsync(final DeleteReportDefinitionRequest request, final AsyncHandler<DeleteReportDefinitionRequest, DeleteReportDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteReportDefinitionResult>(){

            @Override
            public DeleteReportDefinitionResult call() throws Exception {
                DeleteReportDefinitionResult result;
                try {
                    result = AWSCostAndUsageReportAsyncClient.this.deleteReportDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReportDefinitionsResult> describeReportDefinitionsAsync(DescribeReportDefinitionsRequest request) {
        return this.describeReportDefinitionsAsync(request, null);
    }

    @Override
    public Future<DescribeReportDefinitionsResult> describeReportDefinitionsAsync(final DescribeReportDefinitionsRequest request, final AsyncHandler<DescribeReportDefinitionsRequest, DescribeReportDefinitionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReportDefinitionsResult>(){

            @Override
            public DescribeReportDefinitionsResult call() throws Exception {
                DescribeReportDefinitionsResult result;
                try {
                    result = AWSCostAndUsageReportAsyncClient.this.describeReportDefinitions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutReportDefinitionResult> putReportDefinitionAsync(PutReportDefinitionRequest request) {
        return this.putReportDefinitionAsync(request, null);
    }

    @Override
    public Future<PutReportDefinitionResult> putReportDefinitionAsync(final PutReportDefinitionRequest request, final AsyncHandler<PutReportDefinitionRequest, PutReportDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutReportDefinitionResult>(){

            @Override
            public PutReportDefinitionResult call() throws Exception {
                PutReportDefinitionResult result;
                try {
                    result = AWSCostAndUsageReportAsyncClient.this.putReportDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

