/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetComplianceSummaryByResourceTypeRequestMarshaller
implements Marshaller<Request<GetComplianceSummaryByResourceTypeRequest>, GetComplianceSummaryByResourceTypeRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetComplianceSummaryByResourceTypeRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetComplianceSummaryByResourceTypeRequest> marshall(GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        if (getComplianceSummaryByResourceTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetComplianceSummaryByResourceTypeRequest> request = new DefaultRequest<GetComplianceSummaryByResourceTypeRequest>(getComplianceSummaryByResourceTypeRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.GetComplianceSummaryByResourceType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList resourceTypesList = (SdkInternalList)getComplianceSummaryByResourceTypeRequest.getResourceTypes();
            if (!resourceTypesList.isEmpty() || !resourceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ResourceTypes");
                jsonGenerator.writeStartArray();
                for (String resourceTypesListValue : resourceTypesList) {
                    if (resourceTypesListValue == null) continue;
                    jsonGenerator.writeValue(resourceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

