/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ListGroupsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListGroupsRequestMarshaller
implements Marshaller<Request<ListGroupsRequest>, ListGroupsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListGroupsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListGroupsRequest> marshall(ListGroupsRequest listGroupsRequest) {
        if (listGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGroupsRequest> request = new DefaultRequest<ListGroupsRequest>(listGroupsRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ListGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listGroupsRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(listGroupsRequest.getUserPoolId());
            }
            if (listGroupsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listGroupsRequest.getLimit());
            }
            if (listGroupsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listGroupsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

