/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminListGroupsForUserRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AdminListGroupsForUserRequestMarshaller
implements Marshaller<Request<AdminListGroupsForUserRequest>, AdminListGroupsForUserRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AdminListGroupsForUserRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AdminListGroupsForUserRequest> marshall(AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        if (adminListGroupsForUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminListGroupsForUserRequest> request = new DefaultRequest<AdminListGroupsForUserRequest>(adminListGroupsForUserRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminListGroupsForUser");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminListGroupsForUserRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminListGroupsForUserRequest.getUsername());
            }
            if (adminListGroupsForUserRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminListGroupsForUserRequest.getUserPoolId());
            }
            if (adminListGroupsForUserRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(adminListGroupsForUserRequest.getLimit());
            }
            if (adminListGroupsForUserRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(adminListGroupsForUserRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

