/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.RoleMapping;
import com.amazonaws.services.cognitoidentity.model.transform.RulesConfigurationTypeJsonMarshaller;

public class RoleMappingJsonMarshaller {
    private static RoleMappingJsonMarshaller instance;

    public void marshall(RoleMapping roleMapping, StructuredJsonGenerator jsonGenerator) {
        if (roleMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (roleMapping.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(roleMapping.getType());
            }
            if (roleMapping.getAmbiguousRoleResolution() != null) {
                jsonGenerator.writeFieldName("AmbiguousRoleResolution").writeValue(roleMapping.getAmbiguousRoleResolution());
            }
            if (roleMapping.getRulesConfiguration() != null) {
                jsonGenerator.writeFieldName("RulesConfiguration");
                RulesConfigurationTypeJsonMarshaller.getInstance().marshall(roleMapping.getRulesConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RoleMappingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RoleMappingJsonMarshaller();
        }
        return instance;
    }
}

