/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionDeclaration;
import com.amazonaws.services.codepipeline.model.BlockerDeclaration;
import com.amazonaws.services.codepipeline.model.StageDeclaration;
import com.amazonaws.services.codepipeline.model.transform.ActionDeclarationJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.BlockerDeclarationJsonMarshaller;
import java.util.List;

public class StageDeclarationJsonMarshaller {
    private static StageDeclarationJsonMarshaller instance;

    public void marshall(StageDeclaration stageDeclaration, StructuredJsonGenerator jsonGenerator) {
        if (stageDeclaration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActionDeclaration> actionsList;
            List<BlockerDeclaration> blockersList;
            jsonGenerator.writeStartObject();
            if (stageDeclaration.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(stageDeclaration.getName());
            }
            if ((blockersList = stageDeclaration.getBlockers()) != null) {
                jsonGenerator.writeFieldName("blockers");
                jsonGenerator.writeStartArray();
                for (BlockerDeclaration blockersListValue : blockersList) {
                    if (blockersListValue == null) continue;
                    BlockerDeclarationJsonMarshaller.getInstance().marshall(blockersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((actionsList = stageDeclaration.getActions()) != null) {
                jsonGenerator.writeFieldName("actions");
                jsonGenerator.writeStartArray();
                for (ActionDeclaration actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionDeclarationJsonMarshaller.getInstance().marshall(actionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StageDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StageDeclarationJsonMarshaller();
        }
        return instance;
    }
}

