/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetBranchRequestMarshaller
implements Marshaller<Request<GetBranchRequest>, GetBranchRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetBranchRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetBranchRequest> marshall(GetBranchRequest getBranchRequest) {
        if (getBranchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBranchRequest> request = new DefaultRequest<GetBranchRequest>(getBranchRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.GetBranch");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getBranchRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(getBranchRequest.getRepositoryName());
            }
            if (getBranchRequest.getBranchName() != null) {
                jsonGenerator.writeFieldName("branchName").writeValue(getBranchRequest.getBranchName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

