/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.ContainerDetail;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.MountPoint;
import com.amazonaws.services.batch.model.Ulimit;
import com.amazonaws.services.batch.model.Volume;
import com.amazonaws.services.batch.model.transform.KeyValuePairJsonMarshaller;
import com.amazonaws.services.batch.model.transform.MountPointJsonMarshaller;
import com.amazonaws.services.batch.model.transform.UlimitJsonMarshaller;
import com.amazonaws.services.batch.model.transform.VolumeJsonMarshaller;
import java.util.List;

public class ContainerDetailJsonMarshaller {
    private static ContainerDetailJsonMarshaller instance;

    public void marshall(ContainerDetail containerDetail, StructuredJsonGenerator jsonGenerator) {
        if (containerDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Ulimit> list;
            List<MountPoint> list2;
            List<KeyValuePair> list3;
            List<Volume> volumesList;
            List<String> commandList;
            jsonGenerator.writeStartObject();
            if (containerDetail.getImage() != null) {
                jsonGenerator.writeFieldName("image").writeValue(containerDetail.getImage());
            }
            if (containerDetail.getVcpus() != null) {
                jsonGenerator.writeFieldName("vcpus").writeValue(containerDetail.getVcpus());
            }
            if (containerDetail.getMemory() != null) {
                jsonGenerator.writeFieldName("memory").writeValue(containerDetail.getMemory());
            }
            if ((commandList = containerDetail.getCommand()) != null) {
                jsonGenerator.writeFieldName("command");
                jsonGenerator.writeStartArray();
                for (String string : commandList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDetail.getJobRoleArn() != null) {
                jsonGenerator.writeFieldName("jobRoleArn").writeValue(containerDetail.getJobRoleArn());
            }
            if ((volumesList = containerDetail.getVolumes()) != null) {
                jsonGenerator.writeFieldName("volumes");
                jsonGenerator.writeStartArray();
                for (Volume volume : volumesList) {
                    if (volume == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volume, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list3 = containerDetail.getEnvironment()) != null) {
                jsonGenerator.writeFieldName("environment");
                jsonGenerator.writeStartArray();
                for (KeyValuePair keyValuePair : list3) {
                    if (keyValuePair == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(keyValuePair, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = containerDetail.getMountPoints()) != null) {
                jsonGenerator.writeFieldName("mountPoints");
                jsonGenerator.writeStartArray();
                for (MountPoint mountPointsListValue : list2) {
                    if (mountPointsListValue == null) continue;
                    MountPointJsonMarshaller.getInstance().marshall(mountPointsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDetail.getReadonlyRootFilesystem() != null) {
                jsonGenerator.writeFieldName("readonlyRootFilesystem").writeValue(containerDetail.getReadonlyRootFilesystem());
            }
            if ((list = containerDetail.getUlimits()) != null) {
                jsonGenerator.writeFieldName("ulimits");
                jsonGenerator.writeStartArray();
                for (Ulimit ulimitsListValue : list) {
                    if (ulimitsListValue == null) continue;
                    UlimitJsonMarshaller.getInstance().marshall(ulimitsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDetail.getPrivileged() != null) {
                jsonGenerator.writeFieldName("privileged").writeValue(containerDetail.getPrivileged());
            }
            if (containerDetail.getUser() != null) {
                jsonGenerator.writeFieldName("user").writeValue(containerDetail.getUser());
            }
            if (containerDetail.getExitCode() != null) {
                jsonGenerator.writeFieldName("exitCode").writeValue(containerDetail.getExitCode());
            }
            if (containerDetail.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(containerDetail.getReason());
            }
            if (containerDetail.getContainerInstanceArn() != null) {
                jsonGenerator.writeFieldName("containerInstanceArn").writeValue(containerDetail.getContainerInstanceArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerDetailJsonMarshaller();
        }
        return instance;
    }
}

