/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.ExpireSessionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ExpireSessionRequestMarshaller
implements Marshaller<Request<ExpireSessionRequest>, ExpireSessionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ExpireSessionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ExpireSessionRequest> marshall(ExpireSessionRequest expireSessionRequest) {
        if (expireSessionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ExpireSessionRequest> request = new DefaultRequest<ExpireSessionRequest>(expireSessionRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.ExpireSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (expireSessionRequest.getSessionId() != null) {
                jsonGenerator.writeFieldName("SessionId").writeValue(expireSessionRequest.getSessionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

