/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.SdkConfigurationProperty;
import com.amazonaws.services.apigateway.model.SdkType;
import com.amazonaws.services.apigateway.model.transform.SdkConfigurationPropertyJsonMarshaller;
import java.util.List;

public class SdkTypeJsonMarshaller {
    private static SdkTypeJsonMarshaller instance;

    public void marshall(SdkType sdkType, StructuredJsonGenerator jsonGenerator) {
        if (sdkType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<SdkConfigurationProperty> configurationPropertiesList;
            jsonGenerator.writeStartObject();
            if (sdkType.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(sdkType.getId());
            }
            if (sdkType.getFriendlyName() != null) {
                jsonGenerator.writeFieldName("friendlyName").writeValue(sdkType.getFriendlyName());
            }
            if (sdkType.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(sdkType.getDescription());
            }
            if ((configurationPropertiesList = sdkType.getConfigurationProperties()) != null) {
                jsonGenerator.writeFieldName("configurationProperties");
                jsonGenerator.writeStartArray();
                for (SdkConfigurationProperty configurationPropertiesListValue : configurationPropertiesList) {
                    if (configurationPropertiesListValue == null) continue;
                    SdkConfigurationPropertyJsonMarshaller.getInstance().marshall(configurationPropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SdkTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SdkTypeJsonMarshaller();
        }
        return instance;
    }
}

