/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.DeleteResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DeleteResourceRequestMarshaller
implements Marshaller<Request<DeleteResourceRequest>, DeleteResourceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteResourceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteResourceRequest> marshall(DeleteResourceRequest deleteResourceRequest) {
        if (deleteResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteResourceRequest> request = new DefaultRequest<DeleteResourceRequest>(deleteResourceRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", deleteResourceRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "resource_id", deleteResourceRequest.getResourceId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

