/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class BatchGetTracesRequestMarshaller
implements Marshaller<Request<BatchGetTracesRequest>, BatchGetTracesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public BatchGetTracesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchGetTracesRequest> marshall(BatchGetTracesRequest batchGetTracesRequest) {
        if (batchGetTracesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetTracesRequest> request = new DefaultRequest<BatchGetTracesRequest>(batchGetTracesRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/Traces";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> traceIdsList = batchGetTracesRequest.getTraceIds();
            if (traceIdsList != null) {
                jsonGenerator.writeFieldName("TraceIds");
                jsonGenerator.writeStartArray();
                for (String traceIdsListValue : traceIdsList) {
                    if (traceIdsListValue == null) continue;
                    jsonGenerator.writeValue(traceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (batchGetTracesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(batchGetTracesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

