/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddCommunicationToCaseRequestMarshaller
implements Marshaller<Request<AddCommunicationToCaseRequest>, AddCommunicationToCaseRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddCommunicationToCaseRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddCommunicationToCaseRequest> marshall(AddCommunicationToCaseRequest addCommunicationToCaseRequest) {
        if (addCommunicationToCaseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddCommunicationToCaseRequest> request = new DefaultRequest<AddCommunicationToCaseRequest>(addCommunicationToCaseRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.AddCommunicationToCase");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ccEmailAddressesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addCommunicationToCaseRequest.getCaseId() != null) {
                jsonGenerator.writeFieldName("caseId").writeValue(addCommunicationToCaseRequest.getCaseId());
            }
            if (addCommunicationToCaseRequest.getCommunicationBody() != null) {
                jsonGenerator.writeFieldName("communicationBody").writeValue(addCommunicationToCaseRequest.getCommunicationBody());
            }
            if (!(ccEmailAddressesList = (SdkInternalList)addCommunicationToCaseRequest.getCcEmailAddresses()).isEmpty() || !ccEmailAddressesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ccEmailAddresses");
                jsonGenerator.writeStartArray();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonGenerator.writeValue(ccEmailAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (addCommunicationToCaseRequest.getAttachmentSetId() != null) {
                jsonGenerator.writeFieldName("attachmentSetId").writeValue(addCommunicationToCaseRequest.getAttachmentSetId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

