/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.CancelRetrievalRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CancelRetrievalRequestMarshaller
implements Marshaller<Request<CancelRetrievalRequest>, CancelRetrievalRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CancelRetrievalRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CancelRetrievalRequest> marshall(CancelRetrievalRequest cancelRetrievalRequest) {
        if (cancelRetrievalRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelRetrievalRequest> request = new DefaultRequest<CancelRetrievalRequest>(cancelRetrievalRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.CancelRetrieval");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (cancelRetrievalRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(cancelRetrievalRequest.getGatewayARN());
            }
            if (cancelRetrievalRequest.getTapeARN() != null) {
                jsonGenerator.writeFieldName("TapeARN").writeValue(cancelRetrievalRequest.getTapeARN());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

