/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.GetInventoryRequest;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ResultAttribute;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryFilterJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ResultAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetInventoryRequestMarshaller
implements Marshaller<Request<GetInventoryRequest>, GetInventoryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetInventoryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetInventoryRequest> marshall(GetInventoryRequest getInventoryRequest) {
        if (getInventoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetInventoryRequest> request = new DefaultRequest<GetInventoryRequest>(getInventoryRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.GetInventory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList resultAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList filtersList = (SdkInternalList)getInventoryRequest.getFilters();
            if (!filtersList.isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (Object filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    InventoryFilterJsonMarshaller.getInstance().marshall((InventoryFilter)filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(resultAttributesList = (SdkInternalList)getInventoryRequest.getResultAttributes()).isEmpty() || !resultAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ResultAttributes");
                jsonGenerator.writeStartArray();
                for (ResultAttribute resultAttributesListValue : resultAttributesList) {
                    if (resultAttributesListValue == null) continue;
                    ResultAttributeJsonMarshaller.getInstance().marshall(resultAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (getInventoryRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getInventoryRequest.getNextToken());
            }
            if (getInventoryRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(getInventoryRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

