/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.AutomationExecution;
import com.amazonaws.services.simplesystemsmanagement.model.StepExecution;
import com.amazonaws.services.simplesystemsmanagement.model.transform.StepExecutionJsonMarshaller;
import java.util.List;
import java.util.Map;

public class AutomationExecutionJsonMarshaller {
    private static AutomationExecutionJsonMarshaller instance;

    public void marshall(AutomationExecution automationExecution, StructuredJsonGenerator jsonGenerator) {
        if (automationExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, List<String>> outputsMap;
            Map<String, List<String>> parametersMap;
            SdkInternalList stepExecutionsList;
            jsonGenerator.writeStartObject();
            if (automationExecution.getAutomationExecutionId() != null) {
                jsonGenerator.writeFieldName("AutomationExecutionId").writeValue(automationExecution.getAutomationExecutionId());
            }
            if (automationExecution.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(automationExecution.getDocumentName());
            }
            if (automationExecution.getDocumentVersion() != null) {
                jsonGenerator.writeFieldName("DocumentVersion").writeValue(automationExecution.getDocumentVersion());
            }
            if (automationExecution.getExecutionStartTime() != null) {
                jsonGenerator.writeFieldName("ExecutionStartTime").writeValue(automationExecution.getExecutionStartTime());
            }
            if (automationExecution.getExecutionEndTime() != null) {
                jsonGenerator.writeFieldName("ExecutionEndTime").writeValue(automationExecution.getExecutionEndTime());
            }
            if (automationExecution.getAutomationExecutionStatus() != null) {
                jsonGenerator.writeFieldName("AutomationExecutionStatus").writeValue(automationExecution.getAutomationExecutionStatus());
            }
            if (!(stepExecutionsList = (SdkInternalList)automationExecution.getStepExecutions()).isEmpty() || !stepExecutionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StepExecutions");
                jsonGenerator.writeStartArray();
                for (Object stepExecutionsListValue : stepExecutionsList) {
                    if (stepExecutionsListValue == null) continue;
                    StepExecutionJsonMarshaller.getInstance().marshall((StepExecution)stepExecutionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((parametersMap = automationExecution.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : parametersMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : (List)entry.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if ((outputsMap = automationExecution.getOutputs()) != null) {
                jsonGenerator.writeFieldName("Outputs");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> outputsMapValue : outputsMap.entrySet()) {
                    if (outputsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(outputsMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String outputsMapValueList : outputsMapValue.getValue()) {
                        if (outputsMapValueList == null) continue;
                        jsonGenerator.writeValue(outputsMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (automationExecution.getFailureMessage() != null) {
                jsonGenerator.writeFieldName("FailureMessage").writeValue(automationExecution.getFailureMessage());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AutomationExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutomationExecutionJsonMarshaller();
        }
        return instance;
    }
}

