/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.ViewBillingRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ViewBillingRequestMarshaller
implements Marshaller<Request<ViewBillingRequest>, ViewBillingRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ViewBillingRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ViewBillingRequest> marshall(ViewBillingRequest viewBillingRequest) {
        if (viewBillingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ViewBillingRequest> request = new DefaultRequest<ViewBillingRequest>(viewBillingRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.ViewBilling");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (viewBillingRequest.getStart() != null) {
                jsonGenerator.writeFieldName("Start").writeValue(viewBillingRequest.getStart());
            }
            if (viewBillingRequest.getEnd() != null) {
                jsonGenerator.writeFieldName("End").writeValue(viewBillingRequest.getEnd());
            }
            if (viewBillingRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(viewBillingRequest.getMarker());
            }
            if (viewBillingRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue(viewBillingRequest.getMaxItems());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

