/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.Tag;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateTagsForDomainRequestMarshaller
implements Marshaller<Request<UpdateTagsForDomainRequest>, UpdateTagsForDomainRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateTagsForDomainRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateTagsForDomainRequest> marshall(UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        if (updateTagsForDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTagsForDomainRequest> request = new DefaultRequest<UpdateTagsForDomainRequest>(updateTagsForDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateTagsForDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsToUpdateList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateTagsForDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(updateTagsForDomainRequest.getDomainName());
            }
            if (!(tagsToUpdateList = (SdkInternalList)updateTagsForDomainRequest.getTagsToUpdate()).isEmpty() || !tagsToUpdateList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsToUpdate");
                jsonGenerator.writeStartArray();
                for (Tag tagsToUpdateListValue : tagsToUpdateList) {
                    if (tagsToUpdateListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsToUpdateListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

