/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.transform.S3DataSpecJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDataSourceFromS3RequestMarshaller
implements Marshaller<Request<CreateDataSourceFromS3Request>, CreateDataSourceFromS3Request> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateDataSourceFromS3RequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDataSourceFromS3Request> marshall(CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        if (createDataSourceFromS3Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDataSourceFromS3Request> request = new DefaultRequest<CreateDataSourceFromS3Request>(createDataSourceFromS3Request, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateDataSourceFromS3");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDataSourceFromS3Request.getDataSourceId() != null) {
                jsonGenerator.writeFieldName("DataSourceId").writeValue(createDataSourceFromS3Request.getDataSourceId());
            }
            if (createDataSourceFromS3Request.getDataSourceName() != null) {
                jsonGenerator.writeFieldName("DataSourceName").writeValue(createDataSourceFromS3Request.getDataSourceName());
            }
            if (createDataSourceFromS3Request.getDataSpec() != null) {
                jsonGenerator.writeFieldName("DataSpec");
                S3DataSpecJsonMarshaller.getInstance().marshall(createDataSourceFromS3Request.getDataSpec(), jsonGenerator);
            }
            if (createDataSourceFromS3Request.getComputeStatistics() != null) {
                jsonGenerator.writeFieldName("ComputeStatistics").writeValue(createDataSourceFromS3Request.getComputeStatistics());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

