/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.KeyPair;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;

public class KeyPairJsonMarshaller {
    private static KeyPairJsonMarshaller instance;

    public void marshall(KeyPair keyPair, StructuredJsonGenerator jsonGenerator) {
        if (keyPair == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyPair.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(keyPair.getName());
            }
            if (keyPair.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(keyPair.getArn());
            }
            if (keyPair.getSupportCode() != null) {
                jsonGenerator.writeFieldName("supportCode").writeValue(keyPair.getSupportCode());
            }
            if (keyPair.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(keyPair.getCreatedAt());
            }
            if (keyPair.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(keyPair.getLocation(), jsonGenerator);
            }
            if (keyPair.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(keyPair.getResourceType());
            }
            if (keyPair.getFingerprint() != null) {
                jsonGenerator.writeFieldName("fingerprint").writeValue(keyPair.getFingerprint());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyPairJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairJsonMarshaller();
        }
        return instance;
    }
}

