/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.DescribeFindingsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeFindingsRequestMarshaller
implements Marshaller<Request<DescribeFindingsRequest>, DescribeFindingsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeFindingsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeFindingsRequest> marshall(DescribeFindingsRequest describeFindingsRequest) {
        if (describeFindingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFindingsRequest> request = new DefaultRequest<DescribeFindingsRequest>(describeFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> findingArnsList = describeFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonGenerator.writeFieldName("findingArns");
                jsonGenerator.writeStartArray();
                for (String findingArnsListValue : findingArnsList) {
                    if (findingArnsListValue == null) continue;
                    jsonGenerator.writeValue(findingArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeFindingsRequest.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(describeFindingsRequest.getLocale());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

