/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.services.inspector.model.AssessmentRunState;
import com.amazonaws.services.inspector.model.DurationRange;
import com.amazonaws.services.inspector.model.TimestampRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssessmentRunFilter
implements Serializable,
Cloneable {
    private String namePattern;
    private List<String> states;
    private DurationRange durationRange;
    private List<String> rulesPackageArns;
    private TimestampRange startTimeRange;
    private TimestampRange completionTimeRange;
    private TimestampRange stateChangeTimeRange;

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public AssessmentRunFilter withNamePattern(String namePattern) {
        this.setNamePattern(namePattern);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public AssessmentRunFilter withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public AssessmentRunFilter withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public AssessmentRunFilter withStates(AssessmentRunState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (AssessmentRunState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public void setDurationRange(DurationRange durationRange) {
        this.durationRange = durationRange;
    }

    public DurationRange getDurationRange() {
        return this.durationRange;
    }

    public AssessmentRunFilter withDurationRange(DurationRange durationRange) {
        this.setDurationRange(durationRange);
        return this;
    }

    public List<String> getRulesPackageArns() {
        return this.rulesPackageArns;
    }

    public void setRulesPackageArns(Collection<String> rulesPackageArns) {
        if (rulesPackageArns == null) {
            this.rulesPackageArns = null;
            return;
        }
        this.rulesPackageArns = new ArrayList<String>(rulesPackageArns);
    }

    public AssessmentRunFilter withRulesPackageArns(String ... rulesPackageArns) {
        if (this.rulesPackageArns == null) {
            this.setRulesPackageArns(new ArrayList<String>(rulesPackageArns.length));
        }
        for (String ele : rulesPackageArns) {
            this.rulesPackageArns.add(ele);
        }
        return this;
    }

    public AssessmentRunFilter withRulesPackageArns(Collection<String> rulesPackageArns) {
        this.setRulesPackageArns(rulesPackageArns);
        return this;
    }

    public void setStartTimeRange(TimestampRange startTimeRange) {
        this.startTimeRange = startTimeRange;
    }

    public TimestampRange getStartTimeRange() {
        return this.startTimeRange;
    }

    public AssessmentRunFilter withStartTimeRange(TimestampRange startTimeRange) {
        this.setStartTimeRange(startTimeRange);
        return this;
    }

    public void setCompletionTimeRange(TimestampRange completionTimeRange) {
        this.completionTimeRange = completionTimeRange;
    }

    public TimestampRange getCompletionTimeRange() {
        return this.completionTimeRange;
    }

    public AssessmentRunFilter withCompletionTimeRange(TimestampRange completionTimeRange) {
        this.setCompletionTimeRange(completionTimeRange);
        return this;
    }

    public void setStateChangeTimeRange(TimestampRange stateChangeTimeRange) {
        this.stateChangeTimeRange = stateChangeTimeRange;
    }

    public TimestampRange getStateChangeTimeRange() {
        return this.stateChangeTimeRange;
    }

    public AssessmentRunFilter withStateChangeTimeRange(TimestampRange stateChangeTimeRange) {
        this.setStateChangeTimeRange(stateChangeTimeRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamePattern() != null) {
            sb.append("NamePattern: ").append(this.getNamePattern()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getDurationRange() != null) {
            sb.append("DurationRange: ").append(this.getDurationRange()).append(",");
        }
        if (this.getRulesPackageArns() != null) {
            sb.append("RulesPackageArns: ").append(this.getRulesPackageArns()).append(",");
        }
        if (this.getStartTimeRange() != null) {
            sb.append("StartTimeRange: ").append(this.getStartTimeRange()).append(",");
        }
        if (this.getCompletionTimeRange() != null) {
            sb.append("CompletionTimeRange: ").append(this.getCompletionTimeRange()).append(",");
        }
        if (this.getStateChangeTimeRange() != null) {
            sb.append("StateChangeTimeRange: ").append(this.getStateChangeTimeRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunFilter)) {
            return false;
        }
        AssessmentRunFilter other = (AssessmentRunFilter)obj;
        if (other.getNamePattern() == null ^ this.getNamePattern() == null) {
            return false;
        }
        if (other.getNamePattern() != null && !other.getNamePattern().equals(this.getNamePattern())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getDurationRange() == null ^ this.getDurationRange() == null) {
            return false;
        }
        if (other.getDurationRange() != null && !other.getDurationRange().equals(this.getDurationRange())) {
            return false;
        }
        if (other.getRulesPackageArns() == null ^ this.getRulesPackageArns() == null) {
            return false;
        }
        if (other.getRulesPackageArns() != null && !other.getRulesPackageArns().equals(this.getRulesPackageArns())) {
            return false;
        }
        if (other.getStartTimeRange() == null ^ this.getStartTimeRange() == null) {
            return false;
        }
        if (other.getStartTimeRange() != null && !other.getStartTimeRange().equals(this.getStartTimeRange())) {
            return false;
        }
        if (other.getCompletionTimeRange() == null ^ this.getCompletionTimeRange() == null) {
            return false;
        }
        if (other.getCompletionTimeRange() != null && !other.getCompletionTimeRange().equals(this.getCompletionTimeRange())) {
            return false;
        }
        if (other.getStateChangeTimeRange() == null ^ this.getStateChangeTimeRange() == null) {
            return false;
        }
        return other.getStateChangeTimeRange() == null || other.getStateChangeTimeRange().equals(this.getStateChangeTimeRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamePattern() == null ? 0 : this.getNamePattern().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getDurationRange() == null ? 0 : this.getDurationRange().hashCode());
        hashCode = 31 * hashCode + (this.getRulesPackageArns() == null ? 0 : this.getRulesPackageArns().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimeRange() == null ? 0 : this.getStartTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getCompletionTimeRange() == null ? 0 : this.getCompletionTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getStateChangeTimeRange() == null ? 0 : this.getStateChangeTimeRange().hashCode());
        return hashCode;
    }

    public AssessmentRunFilter clone() {
        try {
            return (AssessmentRunFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

