/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListClustersRequestMarshaller
implements Marshaller<Request<ListClustersRequest>, ListClustersRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListClustersRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListClustersRequest> marshall(ListClustersRequest listClustersRequest) {
        if (listClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListClustersRequest> request = new DefaultRequest<ListClustersRequest>(listClustersRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListClusters");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList clusterStatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listClustersRequest.getCreatedAfter() != null) {
                jsonGenerator.writeFieldName("CreatedAfter").writeValue(listClustersRequest.getCreatedAfter());
            }
            if (listClustersRequest.getCreatedBefore() != null) {
                jsonGenerator.writeFieldName("CreatedBefore").writeValue(listClustersRequest.getCreatedBefore());
            }
            if (!(clusterStatesList = (SdkInternalList)listClustersRequest.getClusterStates()).isEmpty() || !clusterStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ClusterStates");
                jsonGenerator.writeStartArray();
                for (String clusterStatesListValue : clusterStatesList) {
                    if (clusterStatesListValue == null) continue;
                    jsonGenerator.writeValue(clusterStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listClustersRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listClustersRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

