/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ReplicationTask;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationTaskStatsJsonMarshaller;

public class ReplicationTaskJsonMarshaller {
    private static ReplicationTaskJsonMarshaller instance;

    public void marshall(ReplicationTask replicationTask, StructuredJsonGenerator jsonGenerator) {
        if (replicationTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (replicationTask.getReplicationTaskIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskIdentifier").writeValue(replicationTask.getReplicationTaskIdentifier());
            }
            if (replicationTask.getSourceEndpointArn() != null) {
                jsonGenerator.writeFieldName("SourceEndpointArn").writeValue(replicationTask.getSourceEndpointArn());
            }
            if (replicationTask.getTargetEndpointArn() != null) {
                jsonGenerator.writeFieldName("TargetEndpointArn").writeValue(replicationTask.getTargetEndpointArn());
            }
            if (replicationTask.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(replicationTask.getReplicationInstanceArn());
            }
            if (replicationTask.getMigrationType() != null) {
                jsonGenerator.writeFieldName("MigrationType").writeValue(replicationTask.getMigrationType());
            }
            if (replicationTask.getTableMappings() != null) {
                jsonGenerator.writeFieldName("TableMappings").writeValue(replicationTask.getTableMappings());
            }
            if (replicationTask.getReplicationTaskSettings() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskSettings").writeValue(replicationTask.getReplicationTaskSettings());
            }
            if (replicationTask.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(replicationTask.getStatus());
            }
            if (replicationTask.getLastFailureMessage() != null) {
                jsonGenerator.writeFieldName("LastFailureMessage").writeValue(replicationTask.getLastFailureMessage());
            }
            if (replicationTask.getStopReason() != null) {
                jsonGenerator.writeFieldName("StopReason").writeValue(replicationTask.getStopReason());
            }
            if (replicationTask.getReplicationTaskCreationDate() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskCreationDate").writeValue(replicationTask.getReplicationTaskCreationDate());
            }
            if (replicationTask.getReplicationTaskStartDate() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskStartDate").writeValue(replicationTask.getReplicationTaskStartDate());
            }
            if (replicationTask.getReplicationTaskArn() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskArn").writeValue(replicationTask.getReplicationTaskArn());
            }
            if (replicationTask.getReplicationTaskStats() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskStats");
                ReplicationTaskStatsJsonMarshaller.getInstance().marshall(replicationTask.getReplicationTaskStats(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationTaskJsonMarshaller();
        }
        return instance;
    }
}

