/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.UpdateApplicationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateApplicationRequestMarshaller
implements Marshaller<Request<UpdateApplicationRequest>, UpdateApplicationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateApplicationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateApplicationRequest> marshall(UpdateApplicationRequest updateApplicationRequest) {
        if (updateApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateApplicationRequest> request = new DefaultRequest<UpdateApplicationRequest>(updateApplicationRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.UpdateApplication");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateApplicationRequest.getConfigurationId() != null) {
                jsonGenerator.writeFieldName("configurationId").writeValue(updateApplicationRequest.getConfigurationId());
            }
            if (updateApplicationRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(updateApplicationRequest.getName());
            }
            if (updateApplicationRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(updateApplicationRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

