/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetSdkTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetSdkTypesRequestMarshaller
implements Marshaller<Request<GetSdkTypesRequest>, GetSdkTypesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetSdkTypesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetSdkTypesRequest> marshall(GetSdkTypesRequest getSdkTypesRequest) {
        if (getSdkTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSdkTypesRequest> request = new DefaultRequest<GetSdkTypesRequest>(getSdkTypesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/sdktypes";
        request.setResourcePath(uriResourcePath);
        if (getSdkTypesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getSdkTypesRequest.getPosition()));
        }
        if (getSdkTypesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getSdkTypesRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

