/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.ListByteMatchSetsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListByteMatchSetsRequestMarshaller
implements Marshaller<Request<ListByteMatchSetsRequest>, ListByteMatchSetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListByteMatchSetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListByteMatchSetsRequest> marshall(ListByteMatchSetsRequest listByteMatchSetsRequest) {
        if (listByteMatchSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListByteMatchSetsRequest> request = new DefaultRequest<ListByteMatchSetsRequest>(listByteMatchSetsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.ListByteMatchSets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listByteMatchSetsRequest.getNextMarker() != null) {
                jsonGenerator.writeFieldName("NextMarker").writeValue(listByteMatchSetsRequest.getNextMarker());
            }
            if (listByteMatchSetsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listByteMatchSetsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

