/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.CancelClusterRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CancelClusterRequestMarshaller
implements Marshaller<Request<CancelClusterRequest>, CancelClusterRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CancelClusterRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CancelClusterRequest> marshall(CancelClusterRequest cancelClusterRequest) {
        if (cancelClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelClusterRequest> request = new DefaultRequest<CancelClusterRequest>(cancelClusterRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.CancelCluster");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (cancelClusterRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(cancelClusterRequest.getClusterId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

