/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeActivityTypeRequestMarshaller
implements Marshaller<Request<DescribeActivityTypeRequest>, DescribeActivityTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeActivityTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeActivityTypeRequest> marshall(DescribeActivityTypeRequest describeActivityTypeRequest) {
        if (describeActivityTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeActivityTypeRequest> request = new DefaultRequest<DescribeActivityTypeRequest>(describeActivityTypeRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.DescribeActivityType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeActivityTypeRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(describeActivityTypeRequest.getDomain());
            }
            if (describeActivityTypeRequest.getActivityType() != null) {
                jsonGenerator.writeFieldName("activityType");
                ActivityTypeJsonMarshaller.getInstance().marshall(describeActivityTypeRequest.getActivityType(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

