/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandRequest;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.NotificationConfigJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class SendCommandRequestMarshaller
implements Marshaller<Request<SendCommandRequest>, SendCommandRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SendCommandRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SendCommandRequest> marshall(SendCommandRequest sendCommandRequest) {
        if (sendCommandRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendCommandRequest> request = new DefaultRequest<SendCommandRequest>(sendCommandRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.SendCommand");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> parametersMap;
            SdkInternalList targetsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList instanceIdsList = (SdkInternalList)sendCommandRequest.getInstanceIds();
            if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (Object instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue((String)instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(targetsList = (SdkInternalList)sendCommandRequest.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Object targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall((Target)targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (sendCommandRequest.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(sendCommandRequest.getDocumentName());
            }
            if (sendCommandRequest.getDocumentHash() != null) {
                jsonGenerator.writeFieldName("DocumentHash").writeValue(sendCommandRequest.getDocumentHash());
            }
            if (sendCommandRequest.getDocumentHashType() != null) {
                jsonGenerator.writeFieldName("DocumentHashType").writeValue(sendCommandRequest.getDocumentHashType());
            }
            if (sendCommandRequest.getTimeoutSeconds() != null) {
                jsonGenerator.writeFieldName("TimeoutSeconds").writeValue(sendCommandRequest.getTimeoutSeconds());
            }
            if (sendCommandRequest.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(sendCommandRequest.getComment());
            }
            if ((parametersMap = sendCommandRequest.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : parametersMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : (List)entry.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (sendCommandRequest.getOutputS3Region() != null) {
                jsonGenerator.writeFieldName("OutputS3Region").writeValue(sendCommandRequest.getOutputS3Region());
            }
            if (sendCommandRequest.getOutputS3BucketName() != null) {
                jsonGenerator.writeFieldName("OutputS3BucketName").writeValue(sendCommandRequest.getOutputS3BucketName());
            }
            if (sendCommandRequest.getOutputS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputS3KeyPrefix").writeValue(sendCommandRequest.getOutputS3KeyPrefix());
            }
            if (sendCommandRequest.getMaxConcurrency() != null) {
                jsonGenerator.writeFieldName("MaxConcurrency").writeValue(sendCommandRequest.getMaxConcurrency());
            }
            if (sendCommandRequest.getMaxErrors() != null) {
                jsonGenerator.writeFieldName("MaxErrors").writeValue(sendCommandRequest.getMaxErrors());
            }
            if (sendCommandRequest.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(sendCommandRequest.getServiceRoleArn());
            }
            if (sendCommandRequest.getNotificationConfig() != null) {
                jsonGenerator.writeFieldName("NotificationConfig");
                NotificationConfigJsonMarshaller.getInstance().marshall(sendCommandRequest.getNotificationConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

