/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.LoggingInfo;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskParameterValueExpression;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskType;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaintenanceWindowTask
implements Serializable,
Cloneable {
    private String windowId;
    private String windowTaskId;
    private String taskArn;
    private String type;
    private SdkInternalList<Target> targets;
    private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private Integer priority;
    private LoggingInfo loggingInfo;
    private String serviceRoleArn;
    private String maxConcurrency;
    private String maxErrors;

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public MaintenanceWindowTask withWindowId(String windowId) {
        this.setWindowId(windowId);
        return this;
    }

    public void setWindowTaskId(String windowTaskId) {
        this.windowTaskId = windowTaskId;
    }

    public String getWindowTaskId() {
        return this.windowTaskId;
    }

    public MaintenanceWindowTask withWindowTaskId(String windowTaskId) {
        this.setWindowTaskId(windowTaskId);
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public MaintenanceWindowTask withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public MaintenanceWindowTask withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(MaintenanceWindowTaskType type) {
        this.type = type.toString();
    }

    public MaintenanceWindowTask withType(MaintenanceWindowTaskType type) {
        this.setType(type);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList<Target>(targets);
    }

    public MaintenanceWindowTask withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new SdkInternalList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public MaintenanceWindowTask withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> getTaskParameters() {
        return this.taskParameters;
    }

    public void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
        this.taskParameters = taskParameters;
    }

    public MaintenanceWindowTask withTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
        this.setTaskParameters(taskParameters);
        return this;
    }

    public MaintenanceWindowTask addTaskParametersEntry(String key, MaintenanceWindowTaskParameterValueExpression value) {
        if (null == this.taskParameters) {
            this.taskParameters = new HashMap<String, MaintenanceWindowTaskParameterValueExpression>();
        }
        if (this.taskParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.taskParameters.put(key, value);
        return this;
    }

    public MaintenanceWindowTask clearTaskParametersEntries() {
        this.taskParameters = null;
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public MaintenanceWindowTask withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public void setLoggingInfo(LoggingInfo loggingInfo) {
        this.loggingInfo = loggingInfo;
    }

    public LoggingInfo getLoggingInfo() {
        return this.loggingInfo;
    }

    public MaintenanceWindowTask withLoggingInfo(LoggingInfo loggingInfo) {
        this.setLoggingInfo(loggingInfo);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public MaintenanceWindowTask withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public MaintenanceWindowTask withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public MaintenanceWindowTask withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWindowId() != null) {
            sb.append("WindowId: " + this.getWindowId() + ",");
        }
        if (this.getWindowTaskId() != null) {
            sb.append("WindowTaskId: " + this.getWindowTaskId() + ",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: " + this.getTaskArn() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: " + this.getTargets() + ",");
        }
        if (this.getTaskParameters() != null) {
            sb.append("TaskParameters: " + this.getTaskParameters() + ",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: " + this.getPriority() + ",");
        }
        if (this.getLoggingInfo() != null) {
            sb.append("LoggingInfo: " + this.getLoggingInfo() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn() + ",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: " + this.getMaxConcurrency() + ",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: " + this.getMaxErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTask)) {
            return false;
        }
        MaintenanceWindowTask other = (MaintenanceWindowTask)obj;
        if (other.getWindowId() == null ^ this.getWindowId() == null) {
            return false;
        }
        if (other.getWindowId() != null && !other.getWindowId().equals(this.getWindowId())) {
            return false;
        }
        if (other.getWindowTaskId() == null ^ this.getWindowTaskId() == null) {
            return false;
        }
        if (other.getWindowTaskId() != null && !other.getWindowTaskId().equals(this.getWindowTaskId())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTaskParameters() == null ^ this.getTaskParameters() == null) {
            return false;
        }
        if (other.getTaskParameters() != null && !other.getTaskParameters().equals(this.getTaskParameters())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getLoggingInfo() == null ^ this.getLoggingInfo() == null) {
            return false;
        }
        if (other.getLoggingInfo() != null && !other.getLoggingInfo().equals(this.getLoggingInfo())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        return other.getMaxErrors() == null || other.getMaxErrors().equals(this.getMaxErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWindowId() == null ? 0 : this.getWindowId().hashCode());
        hashCode = 31 * hashCode + (this.getWindowTaskId() == null ? 0 : this.getWindowTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTaskParameters() == null ? 0 : this.getTaskParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingInfo() == null ? 0 : this.getLoggingInfo().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        return hashCode;
    }

    public MaintenanceWindowTask clone() {
        try {
            return (MaintenanceWindowTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

