/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class SynthesizeSpeechRequestMarshaller
implements Marshaller<Request<SynthesizeSpeechRequest>, SynthesizeSpeechRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SynthesizeSpeechRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SynthesizeSpeechRequest> marshall(SynthesizeSpeechRequest synthesizeSpeechRequest) {
        if (synthesizeSpeechRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SynthesizeSpeechRequest> request = new DefaultRequest<SynthesizeSpeechRequest>(synthesizeSpeechRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/speech";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> lexiconNamesList = synthesizeSpeechRequest.getLexiconNames();
            if (lexiconNamesList != null) {
                jsonGenerator.writeFieldName("LexiconNames");
                jsonGenerator.writeStartArray();
                for (String lexiconNamesListValue : lexiconNamesList) {
                    if (lexiconNamesListValue == null) continue;
                    jsonGenerator.writeValue(lexiconNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (synthesizeSpeechRequest.getOutputFormat() != null) {
                jsonGenerator.writeFieldName("OutputFormat").writeValue(synthesizeSpeechRequest.getOutputFormat());
            }
            if (synthesizeSpeechRequest.getSampleRate() != null) {
                jsonGenerator.writeFieldName("SampleRate").writeValue(synthesizeSpeechRequest.getSampleRate());
            }
            if (synthesizeSpeechRequest.getText() != null) {
                jsonGenerator.writeFieldName("Text").writeValue(synthesizeSpeechRequest.getText());
            }
            if (synthesizeSpeechRequest.getTextType() != null) {
                jsonGenerator.writeFieldName("TextType").writeValue(synthesizeSpeechRequest.getTextType());
            }
            if (synthesizeSpeechRequest.getVoiceId() != null) {
                jsonGenerator.writeFieldName("VoiceId").writeValue(synthesizeSpeechRequest.getVoiceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

