/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetCampaignVersionRequestMarshaller
implements Marshaller<Request<GetCampaignVersionRequest>, GetCampaignVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetCampaignVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetCampaignVersionRequest> marshall(GetCampaignVersionRequest getCampaignVersionRequest) {
        if (getCampaignVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCampaignVersionRequest> request = new DefaultRequest<GetCampaignVersionRequest>(getCampaignVersionRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignVersionRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getCampaignVersionRequest.getApplicationId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignVersionRequest.getCampaignId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getCampaignVersionRequest.getCampaignId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{version}", getCampaignVersionRequest.getVersion() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getCampaignVersionRequest.getVersion()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

