/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.Blueprint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetBlueprintsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Blueprint> blueprints;
    private String nextPageToken;

    public List<Blueprint> getBlueprints() {
        return this.blueprints;
    }

    public void setBlueprints(Collection<Blueprint> blueprints) {
        if (blueprints == null) {
            this.blueprints = null;
            return;
        }
        this.blueprints = new ArrayList<Blueprint>(blueprints);
    }

    public GetBlueprintsResult withBlueprints(Blueprint ... blueprints) {
        if (this.blueprints == null) {
            this.setBlueprints(new ArrayList<Blueprint>(blueprints.length));
        }
        for (Blueprint ele : blueprints) {
            this.blueprints.add(ele);
        }
        return this;
    }

    public GetBlueprintsResult withBlueprints(Collection<Blueprint> blueprints) {
        this.setBlueprints(blueprints);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetBlueprintsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlueprints() != null) {
            sb.append("Blueprints: " + this.getBlueprints() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsResult)) {
            return false;
        }
        GetBlueprintsResult other = (GetBlueprintsResult)obj;
        if (other.getBlueprints() == null ^ this.getBlueprints() == null) {
            return false;
        }
        if (other.getBlueprints() != null && !other.getBlueprints().equals(this.getBlueprints())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlueprints() == null ? 0 : this.getBlueprints().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetBlueprintsResult clone() {
        try {
            return (GetBlueprintsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

