/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SubmitTaskStateChangeRequestMarshaller
implements Marshaller<Request<SubmitTaskStateChangeRequest>, SubmitTaskStateChangeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SubmitTaskStateChangeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SubmitTaskStateChangeRequest> marshall(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        if (submitTaskStateChangeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubmitTaskStateChangeRequest> request = new DefaultRequest<SubmitTaskStateChangeRequest>(submitTaskStateChangeRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.SubmitTaskStateChange");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (submitTaskStateChangeRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(submitTaskStateChangeRequest.getCluster());
            }
            if (submitTaskStateChangeRequest.getTask() != null) {
                jsonGenerator.writeFieldName("task").writeValue(submitTaskStateChangeRequest.getTask());
            }
            if (submitTaskStateChangeRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(submitTaskStateChangeRequest.getStatus());
            }
            if (submitTaskStateChangeRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(submitTaskStateChangeRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

