/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidp.model.transform.AdminCreateUserConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.DeviceConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.EmailConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.SmsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.UserPoolPolicyTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class CreateUserPoolRequestMarshaller
implements Marshaller<Request<CreateUserPoolRequest>, CreateUserPoolRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUserPoolRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateUserPoolRequest> marshall(CreateUserPoolRequest createUserPoolRequest) {
        if (createUserPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserPoolRequest> request = new DefaultRequest<CreateUserPoolRequest>(createUserPoolRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateUserPool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<SchemaAttributeType> list;
            Map<String, String> map;
            List<String> aliasAttributesList;
            List<String> autoVerifiedAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUserPoolRequest.getPoolName() != null) {
                jsonGenerator.writeFieldName("PoolName").writeValue(createUserPoolRequest.getPoolName());
            }
            if (createUserPoolRequest.getPolicies() != null) {
                jsonGenerator.writeFieldName("Policies");
                UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getPolicies(), jsonGenerator);
            }
            if (createUserPoolRequest.getLambdaConfig() != null) {
                jsonGenerator.writeFieldName("LambdaConfig");
                LambdaConfigTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getLambdaConfig(), jsonGenerator);
            }
            if ((autoVerifiedAttributesList = createUserPoolRequest.getAutoVerifiedAttributes()) != null) {
                jsonGenerator.writeFieldName("AutoVerifiedAttributes");
                jsonGenerator.writeStartArray();
                for (String string : autoVerifiedAttributesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((aliasAttributesList = createUserPoolRequest.getAliasAttributes()) != null) {
                jsonGenerator.writeFieldName("AliasAttributes");
                jsonGenerator.writeStartArray();
                for (String string : aliasAttributesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (createUserPoolRequest.getSmsVerificationMessage() != null) {
                jsonGenerator.writeFieldName("SmsVerificationMessage").writeValue(createUserPoolRequest.getSmsVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationMessage() != null) {
                jsonGenerator.writeFieldName("EmailVerificationMessage").writeValue(createUserPoolRequest.getEmailVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationSubject() != null) {
                jsonGenerator.writeFieldName("EmailVerificationSubject").writeValue(createUserPoolRequest.getEmailVerificationSubject());
            }
            if (createUserPoolRequest.getSmsAuthenticationMessage() != null) {
                jsonGenerator.writeFieldName("SmsAuthenticationMessage").writeValue(createUserPoolRequest.getSmsAuthenticationMessage());
            }
            if (createUserPoolRequest.getMfaConfiguration() != null) {
                jsonGenerator.writeFieldName("MfaConfiguration").writeValue(createUserPoolRequest.getMfaConfiguration());
            }
            if (createUserPoolRequest.getDeviceConfiguration() != null) {
                jsonGenerator.writeFieldName("DeviceConfiguration");
                DeviceConfigurationTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getDeviceConfiguration(), jsonGenerator);
            }
            if (createUserPoolRequest.getEmailConfiguration() != null) {
                jsonGenerator.writeFieldName("EmailConfiguration");
                EmailConfigurationTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getEmailConfiguration(), jsonGenerator);
            }
            if (createUserPoolRequest.getSmsConfiguration() != null) {
                jsonGenerator.writeFieldName("SmsConfiguration");
                SmsConfigurationTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getSmsConfiguration(), jsonGenerator);
            }
            if ((map = createUserPoolRequest.getUserPoolTags()) != null) {
                jsonGenerator.writeFieldName("UserPoolTags");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (createUserPoolRequest.getAdminCreateUserConfig() != null) {
                jsonGenerator.writeFieldName("AdminCreateUserConfig");
                AdminCreateUserConfigTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getAdminCreateUserConfig(), jsonGenerator);
            }
            if ((list = createUserPoolRequest.getSchema()) != null) {
                jsonGenerator.writeFieldName("Schema");
                jsonGenerator.writeStartArray();
                for (SchemaAttributeType schemaListValue : list) {
                    if (schemaListValue == null) continue;
                    SchemaAttributeTypeJsonMarshaller.getInstance().marshall(schemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

