/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.CreateGroupRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateGroupRequestMarshaller
implements Marshaller<Request<CreateGroupRequest>, CreateGroupRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateGroupRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateGroupRequest> marshall(CreateGroupRequest createGroupRequest) {
        if (createGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateGroupRequest> request = new DefaultRequest<CreateGroupRequest>(createGroupRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createGroupRequest.getGroupName() != null) {
                jsonGenerator.writeFieldName("GroupName").writeValue(createGroupRequest.getGroupName());
            }
            if (createGroupRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(createGroupRequest.getUserPoolId());
            }
            if (createGroupRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createGroupRequest.getDescription());
            }
            if (createGroupRequest.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(createGroupRequest.getRoleArn());
            }
            if (createGroupRequest.getPrecedence() != null) {
                jsonGenerator.writeFieldName("Precedence").writeValue(createGroupRequest.getPrecedence());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

