/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.RevisionInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetApplicationRevisionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String applicationName;
    private String errorMessage;
    private SdkInternalList<RevisionInfo> revisions;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public BatchGetApplicationRevisionsResult withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public BatchGetApplicationRevisionsResult withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public List<RevisionInfo> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new SdkInternalList();
        }
        return this.revisions;
    }

    public void setRevisions(Collection<RevisionInfo> revisions) {
        if (revisions == null) {
            this.revisions = null;
            return;
        }
        this.revisions = new SdkInternalList<RevisionInfo>(revisions);
    }

    public BatchGetApplicationRevisionsResult withRevisions(RevisionInfo ... revisions) {
        if (this.revisions == null) {
            this.setRevisions(new SdkInternalList<RevisionInfo>(revisions.length));
        }
        for (RevisionInfo ele : revisions) {
            this.revisions.add(ele);
        }
        return this;
    }

    public BatchGetApplicationRevisionsResult withRevisions(Collection<RevisionInfo> revisions) {
        this.setRevisions(revisions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: " + this.getErrorMessage() + ",");
        }
        if (this.getRevisions() != null) {
            sb.append("Revisions: " + this.getRevisions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResult)) {
            return false;
        }
        BatchGetApplicationRevisionsResult other = (BatchGetApplicationRevisionsResult)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getRevisions() == null ^ this.getRevisions() == null) {
            return false;
        }
        return other.getRevisions() == null || other.getRevisions().equals(this.getRevisions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getRevisions() == null ? 0 : this.getRevisions().hashCode());
        return hashCode;
    }

    public BatchGetApplicationRevisionsResult clone() {
        try {
            return (BatchGetApplicationRevisionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

