/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.Tag;
import com.amazonaws.services.codebuild.model.transform.ProjectArtifactsJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectEnvironmentJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectSourceJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateProjectRequestMarshaller
implements Marshaller<Request<CreateProjectRequest>, CreateProjectRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateProjectRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateProjectRequest> marshall(CreateProjectRequest createProjectRequest) {
        if (createProjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateProjectRequest> request = new DefaultRequest<CreateProjectRequest>(createProjectRequest, "AWSCodeBuild");
        request.addHeader("X-Amz-Target", "CodeBuild_20161006.CreateProject");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createProjectRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createProjectRequest.getName());
            }
            if (createProjectRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createProjectRequest.getDescription());
            }
            if (createProjectRequest.getSource() != null) {
                jsonGenerator.writeFieldName("source");
                ProjectSourceJsonMarshaller.getInstance().marshall(createProjectRequest.getSource(), jsonGenerator);
            }
            if (createProjectRequest.getArtifacts() != null) {
                jsonGenerator.writeFieldName("artifacts");
                ProjectArtifactsJsonMarshaller.getInstance().marshall(createProjectRequest.getArtifacts(), jsonGenerator);
            }
            if (createProjectRequest.getEnvironment() != null) {
                jsonGenerator.writeFieldName("environment");
                ProjectEnvironmentJsonMarshaller.getInstance().marshall(createProjectRequest.getEnvironment(), jsonGenerator);
            }
            if (createProjectRequest.getServiceRole() != null) {
                jsonGenerator.writeFieldName("serviceRole").writeValue(createProjectRequest.getServiceRole());
            }
            if (createProjectRequest.getTimeoutInMinutes() != null) {
                jsonGenerator.writeFieldName("timeoutInMinutes").writeValue(createProjectRequest.getTimeoutInMinutes());
            }
            if (createProjectRequest.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey").writeValue(createProjectRequest.getEncryptionKey());
            }
            if ((tagsList = createProjectRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

