/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    @Override
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        if (listInvalidationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInvalidationsRequest> request = new DefaultRequest<ListInvalidationsRequest>(listInvalidationsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-11-25/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", listInvalidationsRequest.getDistributionId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listInvalidationsRequest.getDistributionId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listInvalidationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listInvalidationsRequest.getMarker()));
        }
        if (listInvalidationsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listInvalidationsRequest.getMaxItems()));
        }
        return request;
    }
}

