/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.DescribeJobQueuesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeJobQueuesRequestMarshaller
implements Marshaller<Request<DescribeJobQueuesRequest>, DescribeJobQueuesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeJobQueuesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeJobQueuesRequest> marshall(DescribeJobQueuesRequest describeJobQueuesRequest) {
        if (describeJobQueuesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeJobQueuesRequest> request = new DefaultRequest<DescribeJobQueuesRequest>(describeJobQueuesRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/describejobqueues";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> jobQueuesList = describeJobQueuesRequest.getJobQueues();
            if (jobQueuesList != null) {
                jsonGenerator.writeFieldName("jobQueues");
                jsonGenerator.writeStartArray();
                for (String jobQueuesListValue : jobQueuesList) {
                    if (jobQueuesListValue == null) continue;
                    jsonGenerator.writeValue(jobQueuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeJobQueuesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeJobQueuesRequest.getMaxResults());
            }
            if (describeJobQueuesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeJobQueuesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

