/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.CreateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.transform.ComputeResourceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateComputeEnvironmentRequestMarshaller
implements Marshaller<Request<CreateComputeEnvironmentRequest>, CreateComputeEnvironmentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateComputeEnvironmentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateComputeEnvironmentRequest> marshall(CreateComputeEnvironmentRequest createComputeEnvironmentRequest) {
        if (createComputeEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateComputeEnvironmentRequest> request = new DefaultRequest<CreateComputeEnvironmentRequest>(createComputeEnvironmentRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/createcomputeenvironment";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createComputeEnvironmentRequest.getComputeEnvironmentName() != null) {
                jsonGenerator.writeFieldName("computeEnvironmentName").writeValue(createComputeEnvironmentRequest.getComputeEnvironmentName());
            }
            if (createComputeEnvironmentRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(createComputeEnvironmentRequest.getType());
            }
            if (createComputeEnvironmentRequest.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(createComputeEnvironmentRequest.getState());
            }
            if (createComputeEnvironmentRequest.getComputeResources() != null) {
                jsonGenerator.writeFieldName("computeResources");
                ComputeResourceJsonMarshaller.getInstance().marshall(createComputeEnvironmentRequest.getComputeResources(), jsonGenerator);
            }
            if (createComputeEnvironmentRequest.getServiceRole() != null) {
                jsonGenerator.writeFieldName("serviceRole").writeValue(createComputeEnvironmentRequest.getServiceRole());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

