/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    @Override
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        SdkInternalList metricsList;
        if (enableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableMetricsCollectionRequest> request = new DefaultRequest<EnableMetricsCollectionRequest>(enableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(enableMetricsCollectionRequest.getAutoScalingGroupName()));
        }
        if (!(metricsList = (SdkInternalList)enableMetricsCollectionRequest.getMetrics()).isEmpty() || !metricsList.isAutoConstruct()) {
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString(metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        if (enableMetricsCollectionRequest.getGranularity() != null) {
            request.addParameter("Granularity", StringUtils.fromString(enableMetricsCollectionRequest.getGranularity()));
        }
        return request;
    }
}

