/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetDocumentationPartsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDocumentationPartsRequestMarshaller
implements Marshaller<Request<GetDocumentationPartsRequest>, GetDocumentationPartsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDocumentationPartsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDocumentationPartsRequest> marshall(GetDocumentationPartsRequest getDocumentationPartsRequest) {
        if (getDocumentationPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDocumentationPartsRequest> request = new DefaultRequest<GetDocumentationPartsRequest>(getDocumentationPartsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDocumentationPartsRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDocumentationPartsRequest.getRestApiId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getDocumentationPartsRequest.getType() != null) {
            request.addParameter("type", StringUtils.fromString(getDocumentationPartsRequest.getType()));
        }
        if (getDocumentationPartsRequest.getNameQuery() != null) {
            request.addParameter("name", StringUtils.fromString(getDocumentationPartsRequest.getNameQuery()));
        }
        if (getDocumentationPartsRequest.getPath() != null) {
            request.addParameter("path", StringUtils.fromString(getDocumentationPartsRequest.getPath()));
        }
        if (getDocumentationPartsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getDocumentationPartsRequest.getPosition()));
        }
        if (getDocumentationPartsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getDocumentationPartsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

