/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.services.xray.model.Edge;
import com.amazonaws.services.xray.model.HistogramEntry;
import com.amazonaws.services.xray.model.ServiceStatistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Service
implements Serializable,
Cloneable {
    private Integer referenceId;
    private String name;
    private List<String> names;
    private Boolean root;
    private String accountId;
    private String type;
    private String state;
    private Date startTime;
    private Date endTime;
    private List<Edge> edges;
    private ServiceStatistics summaryStatistics;
    private List<HistogramEntry> durationHistogram;

    public void setReferenceId(Integer referenceId) {
        this.referenceId = referenceId;
    }

    public Integer getReferenceId() {
        return this.referenceId;
    }

    public Service withReferenceId(Integer referenceId) {
        this.setReferenceId(referenceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Service withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(Collection<String> names) {
        if (names == null) {
            this.names = null;
            return;
        }
        this.names = new ArrayList<String>(names);
    }

    public Service withNames(String ... names) {
        if (this.names == null) {
            this.setNames(new ArrayList<String>(names.length));
        }
        for (String ele : names) {
            this.names.add(ele);
        }
        return this;
    }

    public Service withNames(Collection<String> names) {
        this.setNames(names);
        return this;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public Boolean getRoot() {
        return this.root;
    }

    public Service withRoot(Boolean root) {
        this.setRoot(root);
        return this;
    }

    public Boolean isRoot() {
        return this.root;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Service withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Service withType(String type) {
        this.setType(type);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Service withState(String state) {
        this.setState(state);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Service withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Service withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(Collection<Edge> edges) {
        if (edges == null) {
            this.edges = null;
            return;
        }
        this.edges = new ArrayList<Edge>(edges);
    }

    public Service withEdges(Edge ... edges) {
        if (this.edges == null) {
            this.setEdges(new ArrayList<Edge>(edges.length));
        }
        for (Edge ele : edges) {
            this.edges.add(ele);
        }
        return this;
    }

    public Service withEdges(Collection<Edge> edges) {
        this.setEdges(edges);
        return this;
    }

    public void setSummaryStatistics(ServiceStatistics summaryStatistics) {
        this.summaryStatistics = summaryStatistics;
    }

    public ServiceStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public Service withSummaryStatistics(ServiceStatistics summaryStatistics) {
        this.setSummaryStatistics(summaryStatistics);
        return this;
    }

    public List<HistogramEntry> getDurationHistogram() {
        return this.durationHistogram;
    }

    public void setDurationHistogram(Collection<HistogramEntry> durationHistogram) {
        if (durationHistogram == null) {
            this.durationHistogram = null;
            return;
        }
        this.durationHistogram = new ArrayList<HistogramEntry>(durationHistogram);
    }

    public Service withDurationHistogram(HistogramEntry ... durationHistogram) {
        if (this.durationHistogram == null) {
            this.setDurationHistogram(new ArrayList<HistogramEntry>(durationHistogram.length));
        }
        for (HistogramEntry ele : durationHistogram) {
            this.durationHistogram.add(ele);
        }
        return this;
    }

    public Service withDurationHistogram(Collection<HistogramEntry> durationHistogram) {
        this.setDurationHistogram(durationHistogram);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReferenceId() != null) {
            sb.append("ReferenceId: " + this.getReferenceId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getNames() != null) {
            sb.append("Names: " + this.getNames() + ",");
        }
        if (this.getRoot() != null) {
            sb.append("Root: " + this.getRoot() + ",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getEdges() != null) {
            sb.append("Edges: " + this.getEdges() + ",");
        }
        if (this.getSummaryStatistics() != null) {
            sb.append("SummaryStatistics: " + this.getSummaryStatistics() + ",");
        }
        if (this.getDurationHistogram() != null) {
            sb.append("DurationHistogram: " + this.getDurationHistogram());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.getReferenceId() == null ^ this.getReferenceId() == null) {
            return false;
        }
        if (other.getReferenceId() != null && !other.getReferenceId().equals(this.getReferenceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNames() == null ^ this.getNames() == null) {
            return false;
        }
        if (other.getNames() != null && !other.getNames().equals(this.getNames())) {
            return false;
        }
        if (other.getRoot() == null ^ this.getRoot() == null) {
            return false;
        }
        if (other.getRoot() != null && !other.getRoot().equals(this.getRoot())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getEdges() == null ^ this.getEdges() == null) {
            return false;
        }
        if (other.getEdges() != null && !other.getEdges().equals(this.getEdges())) {
            return false;
        }
        if (other.getSummaryStatistics() == null ^ this.getSummaryStatistics() == null) {
            return false;
        }
        if (other.getSummaryStatistics() != null && !other.getSummaryStatistics().equals(this.getSummaryStatistics())) {
            return false;
        }
        if (other.getDurationHistogram() == null ^ this.getDurationHistogram() == null) {
            return false;
        }
        return other.getDurationHistogram() == null || other.getDurationHistogram().equals(this.getDurationHistogram());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReferenceId() == null ? 0 : this.getReferenceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNames() == null ? 0 : this.getNames().hashCode());
        hashCode = 31 * hashCode + (this.getRoot() == null ? 0 : this.getRoot().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getEdges() == null ? 0 : this.getEdges().hashCode());
        hashCode = 31 * hashCode + (this.getSummaryStatistics() == null ? 0 : this.getSummaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getDurationHistogram() == null ? 0 : this.getDurationHistogram().hashCode());
        return hashCode;
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

