/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.StopExecutionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StopExecutionRequestMarshaller
implements Marshaller<Request<StopExecutionRequest>, StopExecutionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StopExecutionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StopExecutionRequest> marshall(StopExecutionRequest stopExecutionRequest) {
        if (stopExecutionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopExecutionRequest> request = new DefaultRequest<StopExecutionRequest>(stopExecutionRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.StopExecution");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (stopExecutionRequest.getExecutionArn() != null) {
                jsonGenerator.writeFieldName("executionArn").writeValue(stopExecutionRequest.getExecutionArn());
            }
            if (stopExecutionRequest.getError() != null) {
                jsonGenerator.writeFieldName("error").writeValue(stopExecutionRequest.getError());
            }
            if (stopExecutionRequest.getCause() != null) {
                jsonGenerator.writeFieldName("cause").writeValue(stopExecutionRequest.getCause());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

