/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeStateMachineRequestMarshaller
implements Marshaller<Request<DescribeStateMachineRequest>, DescribeStateMachineRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeStateMachineRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeStateMachineRequest> marshall(DescribeStateMachineRequest describeStateMachineRequest) {
        if (describeStateMachineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStateMachineRequest> request = new DefaultRequest<DescribeStateMachineRequest>(describeStateMachineRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.DescribeStateMachine");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeStateMachineRequest.getStateMachineArn() != null) {
                jsonGenerator.writeFieldName("stateMachineArn").writeValue(describeStateMachineRequest.getStateMachineArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

